<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Carbon;

use App\Http\Controllers\EncController;

class MCOMAUController extends Controller{
    public function getUsers($idus, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));
        //Se verifica que el usuario enviado exista
        $qryVer = "SELECT * FROM S001V01TUSUA WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce";
        $gstVer = $pdo->prepare($qryVer);
        //Se hace el bind de los elementos
        $gstVer->bindParam(":idus", $idus);
        $gstVer->bindParam(":rfce", $rfce);
        //Se verifica que se pueda ejecutar la consulta
        if(!$gstVer->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUS000: No se ejecutó la consulta de los usuarios", [], 500);
        }
        //Se verifica que el usuario exista
        $usu = $gstVer->fetchObject();
        if(!$usu){
            return $this->makeResponse(true, "ERR_MCOMAU_USU_GUS001: El usuario ingresado no existe", [], 404);
        }
        //Si el usuario existe se procede  buscar el resto de usuarios
        $qryUsu  = 'SELECT USUA_IDUS AS IDUSUARIO, USUA_NUEM AS NUMEMPL, USUA_NOMB AS NOMBRE, USUA_APPA AS APELLIDO_PATERNO, USUA_APMA AS APELLIDO_MATERNO, USUA_RFCU AS RFCUSUARIO, ';
        $qryUsu .= 'USUA_PERF AS PERFIL, USUA_TURN AS TURNO, USUA_COEL AS EMAIL, POLI_NOPO AS POLITICA, USUA_ESTA AS ESTATUS, UNNE_NOUN AS UNIDADNEGOCIO, USUA_FEIN AS FECHA_INGRESO FROM S001V01TUSUA ';
        $qryUsu .= 'INNER JOIN S001V01TUNNE ON UNNE_RFCU = USUA_UNNE INNER JOIN S001V01TPOLI ON POLI_IDPO = USUA_POLI WHERE USUA_IDUS != :idus AND USUA_RFCE = :rfce';
        $gstUsu = $pdo->prepare($qryUsu);
        //Se hace el bind de parametros
        $gstUsu->bindParam(":idus", $idus);
        $gstUsu->bindParam(":rfce", $rfce);
        //Se verifica que se pueda ejecutar la consulta
        if(!$gstUsu->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUS002: No se ejecutó la consulta de los usuarios", [], 500);
        }
        //Retornamos los usuarios
        $usuarios = $gstUsu->fetchAll($pdo::FETCH_ASSOC);
        $usuariosF = array();
        foreach($usuarios as $usuario){
            if(str_contains($usuario['NOMBRE'], "-")){
                $usuario['NOMBRE'] = str_replace("-", "", $usuario['NOMBRE']);
            }
            $usuario['NOMBRE'] = trim($usuario['NOMBRE']);
            $usuariosF[] = $usuario;
        }
        
        return $this->makeResponse(false, "EXITO", $usuariosF);
    }

    public function getUsersAll($rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));
        //Se verifica que el usuario enviado exista
        /* $qryVer = "SELECT * FROM S001V01TUSUA WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce";
        $gstVer = $pdo->prepare($qryVer);
        //Se hace el bind de los elementos
        $gstVer->bindParam(":idus", $idus);
        $gstVer->bindParam(":rfce", $rfce);
        //Se verifica que se pueda ejecutar la consulta
        if(!$gstVer->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUS000: No se ejecutó la consulta de los usuarios", [], 500);
        }
        //Se verifica que el usuario exista
        $usu = $gstVer->fetchObject();
        if(!$usu){
            return $this->makeResponse(true, "ERR_MCOMAU_USU_GUS001: El usuario ingresado no existe", [], 404);
        } */
        //Si el usuario existe se procede  buscar el resto de usuarios
        $qryUsu  = 'SELECT USUA_IDUS AS IDUSUARIO, USUA_NOMB AS NOMBRE, USUA_APPA AS APELLIDO_PATERNO, USUA_APMA AS APELLIDO_MATERNO FROM S001V01TUSUA WHERE USUA_RFCE = :rfce';
        $gstUsu = $pdo->prepare($qryUsu);
        //Se hace el bind de parametros
        $gstUsu->bindParam(":rfce", $rfce);
        //Se verifica que se pueda ejecutar la consulta
        if(!$gstUsu->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUS002: No se ejecutó la consulta de los usuarios", [], 500);
        }
        //Retornamos los usuarios
        $usuarios = $gstUsu->fetchAll($pdo::FETCH_ASSOC);
        $usuariosF = array();
        foreach($usuarios as $usuario){
            if(str_contains($usuario['NOMBRE'], "-")){
                $usuario['NOMBRE'] = str_replace("-", "", $usuario['NOMBRE']);
            }
            $usuario['NOMBRE'] = trim($usuario['NOMBRE']);
            $usuariosF[] = $usuario;
        }
        
        return $this->makeResponse(false, "EXITO", $usuariosF);
    }

    public function register(Request $request){
        $validator = Validator::make($request->all(), [
            'numero_empleado' => 'required|string|max:50',
            'user_id' => 'required|string|max:50',
            'rfc_empresa' => 'required|string',
            'turno' => 'required|string|max:30',
            'perfil' => 'required|integer',
            'politica' => 'required|integer',
            'nombre' => 'required|string|max:50',
            'ape_p' => 'required|string|max:50',
            'rfc_usuario' => 'required|string|max:13',
            'email' => 'required|string|email|max:50',
            'password' => 'required|string|min:8|confirmed',
            'rfc_unidad_negocio' => 'required|string|max:13',
            'fecha_ingreso_laboral' => 'required|date',
            'user_id_empleado_registra' => 'required|string|max:50',
            'user_id_jefe_directo' => 'required|string|max:50',
        ]);

        if ($validator->fails()) {
            return $this->makeResponse(
                true,
                "ERR_MCOMAU_USU_REG000: Se encontraron uno o más errores.",
                $this->makeErrors($validator->errors()->messages()),
                401
            );
        }
        
        $usuarioForm = $request->all();
        $pdo = DB::connection()->getPdo();
        $qryVer = "SELECT * FROM S001V01TUSUA WHERE USUA_COEL = :coel OR USUA_RFCU = :rfcu";
        $gstVer = $pdo->prepare($qryVer);
        
        $gstVer->bindParam(":coel", $usuarioForm['email']);
        $gstVer->bindParam(":rfcu", $usuarioForm['rfc_usuario']);

        if(!$gstVer->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_REG001: No se ejecutó la consulta de los accesos.", [], 500);
        }

        $usuariosReg = $gstVer->fetchAll($pdo::FETCH_ASSOC);

        if(count($usuariosReg) > 0){
            return $this->makeResponse(true, "ERR_MCOMAU_USU_REG002: El correo electrónico o el RFC ya se encuentran registrados.", [], 401);
        }

        $qryIns  = "INSERT INTO S001V01TUSUA (USUA_NUEM, USUA_IDUS, USUA_RFCE, USUA_TURN, USUA_PERF, USUA_POLI, USUA_NOMB, USUA_APPA, USUA_APMA, USUA_RFCU, 
        USUA_COEL, USUA_UNNE, USUA_HICO, USUA_CONT, USUA_FEIN, USUA_USRE, USUA_FERE, USUA_FEAR) VALUES (:nuem, :idus, :rfce, :turn, :perf, :poli, :nomb, :appa, 
        :apma, :rfcu, :coel, :unne, :hico, :cont, :fein, :usre, :fere, CURRENT_TIMESTAMP)";
        $gstIns = $pdo->prepare($qryIns);

        $encriptacion = new EncController();
        $cont = Hash::make($usuarioForm['password']);
        $fere = Carbon::now()->timezone('America/Mexico_City')->toDateTimeString();
        $rfce = $encriptacion->desencriptar($usuarioForm['rfc_empresa']);

        $gstIns->bindParam(":nuem", $usuarioForm['numero_empleado']);
        $gstIns->bindParam(":idus", $usuarioForm['user_id']);
        $gstIns->bindParam(":rfce", $rfce);
        $gstIns->bindParam(":turn", $usuarioForm['turno']);
        $gstIns->bindParam(":perf", $usuarioForm['perfil']);
        $gstIns->bindParam(":poli", $usuarioForm['politica']);
        $gstIns->bindParam(":nomb", $usuarioForm['nombre']);
        $gstIns->bindParam(":appa", $usuarioForm['ape_p']);
        $gstIns->bindParam(":apma", $usuarioForm['ape_m']);
        $gstIns->bindParam(":rfcu", $usuarioForm['rfc_usuario']);
        $gstIns->bindParam(":coel", $usuarioForm['email']);
        $gstIns->bindParam(":unne", $usuarioForm['rfc_unidad_negocio']);
        $gstIns->bindParam(":hico", $cont);
        $gstIns->bindParam(":cont", $cont);
        $gstIns->bindParam(":fein", $usuarioForm['fecha_ingreso_laboral']);
        $gstIns->bindParam(":usre", $usuarioForm['user_id_empleado_registra']);
        $gstIns->bindParam(":fere", $fere);

        if(!$gstIns->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_REG003: No se ejecutó la inserción del usuario a la base.", [], 500);
        }

        $qryOrga = "INSERT INTO S001V01TORGA (ORGA_IDUS, ORGA_RFCE, ORGA_JEDI, ORGA_JESU, ORGA_USRE, ORGA_FERE, ORGA_FEAR) VALUES (:idus, :rfce, :jedi, 
        :jesu, :usre, :fere, CURRENT_TIMESTAMP)";
        $gstOrga = $pdo->prepare($qryOrga);

        $gstOrga->bindParam(":idus", $usuarioForm['user_id']);
        $gstOrga->bindParam(":rfce", $rfce);
        $gstOrga->bindParam(":jedi", $usuarioForm['user_id_jefe_directo']);
        $gstOrga->bindParam(":jesu", $usuarioForm['user_id_jefe_sustituto']);
        $gstOrga->bindParam(":usre", $usuarioForm['user_id_empleado_registra']);
        $gstOrga->bindParam(":fere", $fere);

        if(!$gstOrga->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_REG004: No se ejecutó la inserción del organigrama a la base.", [], 500);
        }

        return $this->makeResponse(false, "EXITO: Usuario registrado");
    }

    public function getUsersMenos($idreq, $idmen, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));

        $qryVer = "SELECT * FROM S001V01TUSUA WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce";
        $gstVer = $pdo->prepare($qryVer);

        $gstVer->bindParam(":idus", $idreq);
        $gstVer->bindParam(":rfce", $rfce);

        if(!$gstVer->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUM000: No se pudieron obtener los datos del usuario que realiza la consulta.", [], 500);
        }

        if(count($gstVer->fetchAll($pdo::FETCH_ASSOC)) < 1){
            return $this->makeResponse(true, "ERR_MCOMAU_USU_GUM001: El usuario que realiza la consulta no existe.", [], 404);
        }

        unset($gstVer);
        $gstVer = $pdo->prepare($qryVer);

        $gstVer->bindParam(":idus", $idmen);
        $gstVer->bindParam(":rfce", $rfce);

        if(!$gstVer->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUM002: No se pudieron obtener los datos del usuario a descartar.", [], 500);
        }

        if(count($gstVer->fetchAll($pdo::FETCH_ASSOC)) < 1){
            return $this->makeResponse(true, "ERR_MCOMAU_USU_GUM003: El usuario a descartar no existe.", [], 404);
        }

        $qryUsu  = 'SELECT USUA_IDUS AS IDUSUARIO, USUA_NUEM AS NUMEMPL, USUA_NOMB AS NOMBRE, USUA_APPA AS APELLIDO_PATERNO, USUA_APMA AS APELLIDO_MATERNO, USUA_RFCU AS RFCUSUARIO, ';
        $qryUsu .= 'USUA_COEL AS EMAIL, USUA_POLI AS POLITICA, USUA_ESTA AS ESTATUS FROM S001V01TUSUA WHERE USUA_IDUS != :nummen AND USUA_RFCE = :rfce';
        $gstUsu = $pdo->prepare($qryUsu);

        $gstUsu->bindParam(":nummen", $idmen);
        $gstUsu->bindParam(":rfce", $rfce);
        
        if (!$gstUsu->execute()) {
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GUM004: No se pudieron obtener los usuarios de la base de datos.", [], 500);
        }

        return $this->makeResponse(false, "EXITO", $gstUsu->fetchAll($pdo::FETCH_ASSOC));
    }

    public function delete(Request $request){
        $validator = Validator::make($request->all(), [
            'numero_empleado' => 'required|string',
            'numero_empleado_modifica' => 'required|string',
        ]);

        if($validator->fails()){
            return $this->makeResponse(
                true,
                "ERR_MCOMAU_USU_DEL000: Se encontraron uno o más errores.",
                $this->makeErrors($validator->errors()->messages()),
                401
            );
        }

        $pdo = DB::connection()->getPdo();
        $eliminar = $request->all();
        
        $qryRFCE = "SELECT USUA_RFCE FROM S001V01TUSUA WHERE USUA_IDUS = :idus";
        $gstRFCE = $pdo->prepare($qryRFCE);
        $gstRFCE->bindParam(":idus", $eliminar['numero_empleado_modifica']);

        $gstRFCE->execute();
        $rfce = $gstRFCE->fetchObject()->USUA_RFCE;

        $qryEmpl = "SELECT ORGA_IDUS FROM S001V01TORGA WHERE (ORGA_JEDI = :jedi OR ORGA_JESU = :jesu) AND ORGA_RFCE = :rfce";
        $gstEmpl = $pdo->prepare($qryEmpl);

        $gstEmpl->bindParam(":jedi", $eliminar['numero_empleado']);
        $gstEmpl->bindParam(":jesu", $eliminar['numero_empleado']);
        $gstEmpl->bindParam(":rfce", $rfce);

        if(!$gstEmpl->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_DEL001: No se pudo consultar el organigrama del usuario.", [], 500);
        }

        $empleados = $gstEmpl->fetchAll($pdo::FETCH_ASSOC);

        if(count($empleados) > 0){
            return $this->makeResponse(true, "ERR_MCOMAU_USU_DEL002: El usuario no puede ser eliminado porque es jefe directo o jefe sustituto en el organigrama.", [], 401);
        }

        $qry = 'UPDATE S001V01TUSUA SET USUA_ESTA = "Eliminado", USUA_USMO = :nummod, USUA_FEMO = :femo WHERE USUA_IDUS = :numreq AND USUA_RFCE = :rfce';
        $gst = $pdo->prepare($qry);

        $femo = Carbon::now()->timezone('America/Mexico_City')->toDateTimeString();

        $gst->bindParam(":nummod", $eliminar['numero_empleado_modifica']);
        $gst->bindParam(":femo", $femo);
        $gst->bindParam(":numreq", $eliminar['numero_empleado']);
        $gst->bindParam(":rfce", $rfce);
        
        if (!$gst->execute()) {
            return $this->makeResponse(true, "ERR_MCOMAU_SER_DEL003: No se pudo eliminar al usuario solicitado.", [], 500);
        }
        return $this->makeResponse(false, "EXITO: Usuario eliminado");
    }

    public function block(Request $request){
        $validator = Validator::make($request->all(), [
            'numero_empleado' => 'required|string',
            'numero_empleado_modifica' => 'required|string',
        ]);

        if($validator->fails()){
            return $this->makeResponse(
                true,
                "ERR_MCOMAU_USU_BLO000: Se encontraron uno o más errores.",
                $this->makeErrors($validator->errors()->messages()),
                401
            );
        }

        $pdo = DB::connection()->getPdo();
        $eliminar = $request->all();

        $qryRFCE = "SELECT USUA_RFCE FROM S001V01TUSUA WHERE USUA_IDUS = :idus";
        $gstRFCE = $pdo->prepare($qryRFCE);
        $gstRFCE->bindParam(":idus", $eliminar['numero_empleado_modifica']);

        $gstRFCE->execute();
        $rfce = $gstRFCE->fetchObject()->USUA_RFCE;

        $qry = 'UPDATE S001V01TUSUA SET USUA_ESTA = "Inactivo", USUA_USMO = :nummod, USUA_FEMO = :femo WHERE USUA_IDUS = :numreq AND USUA_RFCE = :rfce';
        $gst = $pdo->prepare($qry);

        $femo = Carbon::now()->timezone('America/Mexico_City')->toDateTimeString();

        $gst->bindParam(":nummod", $eliminar['numero_empleado_modifica']);
        $gst->bindParam(":femo", $femo);
        $gst->bindParam(":numreq", $eliminar['numero_empleado']);
        $gst->bindParam(":rfce", $rfce);
        
        if (!$gst->execute()) {
            return $this->makeResponse(true, "ERR_MCOMAU_SER_BLO001: No se pudo bloquear al usuario solicitado.", [], 500);
        }
        return $this->makeResponse(false, "EXITO: Usuario bloqueado");
    }

    public function unblock(Request $request){
        $validator = Validator::make($request->all(), [
            'user_id_empleado' => 'required|string',
            'user_id_empleado_modifica' => 'required|string',
        ]);

        if($validator->fails()){
            return $this->makeResponse(
                true,
                "ERR_MCOMAU_USU_UNB000: Se encontraron uno o más errores.",
                $this->makeErrors($validator->errors()->messages()),
                401
            );
        }

        $pdo = DB::connection()->getPdo();
        $eliminar = $request->all();

        $qryRFCE = "SELECT USUA_RFCE FROM S001V01TUSUA WHERE USUA_IDUS = :idus";
        $gstRFCE = $pdo->prepare($qryRFCE);
        $gstRFCE->bindParam(":idus", $eliminar['user_id_empleado_modifica']);

        $gstRFCE->execute();
        $rfce = $gstRFCE->fetchObject()->USUA_RFCE;

        $qry = 'UPDATE S001V01TUSUA SET USUA_ESTA = "Activo", USUA_USMO = :nummod, USUA_FEMO = :femo WHERE USUA_IDUS = :numreq AND USUA_RFCE = :rfce';
        $gst = $pdo->prepare($qry);

        $femo = Carbon::now()->timezone('America/Mexico_City')->toDateTimeString();

        $gst->bindParam(":nummod", $eliminar['user_id_empleado_modifica']);
        $gst->bindParam(":femo", $femo);
        $gst->bindParam(":numreq", $eliminar['user_id_empleado']);
        $gst->bindParam(":rfce", $rfce);
        
        if (!$gst->execute()) {
            return $this->makeResponse(true, "ERR_MCOMAU_SER_UNB001: No se pudo bloquear al usuario solicitado", [], 500);
        }
        return $this->makeResponse(false, "EXITO: Usuario desbloqueado");
    }

    public function changePwd(Request $request){
        $validator = Validator::make($request->all(), [
            'numero_empleado' => 'required|string',
            'numero_empleado_modifica' => 'required|string',
            'password' => 'required|string|min:6|confirmed',
        ]);

        if($validator->fails()){
            return $this->makeResponse(
                true,
                "ERR_MCOMAU_USU_CPW000: Se encontraron uno o más errores.",
                $this->makeErrors($validator->errors()->messages()),
                401
            );
        }

        $pdo = DB::connection()->getPdo();
        $contra = $request->all();
        $qryRFCE = "SELECT USUA_RFCE FROM S001V01TUSUA WHERE USUA_IDUS = :idus";
        $gstRFCE = $pdo->prepare($qryRFCE);
        $gstRFCE->bindParam(":idus", $contra['numero_empleado_modifica']);

        $gstRFCE->execute();
        $rfce = $gstRFCE->fetchObject()->USUA_RFCE;

        $qryPwd = "SELECT USUA_HICO FROM S001V01TUSUA WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce";
        $gstPwd = $pdo->prepare($qryPwd);
        $gstPwd->bindParam(":idus", $contra['numero_empleado']);
        $gstPwd->bindParam(":rfce", $rfce);

        if(!$gstPwd->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_CPW001: No se pudo consultar el historial de contraseñas del usuario.", [], 500);
        }

        $histCont = $gstPwd->fetchobject();
        $histContArr = explode("|", $histCont->USUA_HICO);

        foreach($histContArr as $contStr){
            if(Hash::check($contra['password'], $contStr)){
                return $this->makeResponse(true, "ERR_MCOMAU_SER_CPW002: La contraseña que desea registrar ya fue utilizada previamente", [], 401);
            }
        }

        if(count($histContArr) >= 5){
            array_pop($histContArr);
        }

        $cont = Hash::make($contra['password']);
        $histContStr = $cont;

        foreach($histContArr as $contStr){
            $histContStr .= "|" . $contStr;
        }

        $qry = 'UPDATE S001V01TUSUA SET USUA_ULCC = :ulcc, USUA_HICO = :hico, USUA_CONT = :cont, USUA_USMO = :nummod, USUA_FEMO = :femo WHERE USUA_IDUS = :numreq 
        AND USUA_RFCE = :rfce';
        $gst = $pdo->prepare($qry);
        $femo = Carbon::now()->timezone('America/Mexico_City')->toDateTimeString();

        $gst->bindParam(":ulcc", $femo);
        $gst->bindParam(":hico", $histContStr);
        $gst->bindParam(":cont", $cont);
        $gst->bindParam(":nummod", $contra['numero_empleado_modifica']);
        $gst->bindParam(":femo", $femo);
        $gst->bindParam(":numreq", $contra['numero_empleado']);
        $gst->bindParam(":rfce", $rfce);
        
        if (!$gst->execute()) {
            return $this->makeResponse(true, "ERR_MCOMAU_SER_CPW003: No se pudo cambiar la contraseña al usuario solicitado.", [], 500);
        }
        return $this->makeResponse(false, "EXITO: Contraseña cambiada");
    }

    public function update(Request $request){
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|string|max:50',
            'turno' => 'required|string|max:30',
            'perfil' => 'required|integer',
            'politica' => 'required|integer',
            'nombre' => 'required|string|max:50',
            'ape_p' => 'required|string|max:50',
            'rfc_usuario' => 'required|string|max:13',
            'rfc_unidad_negocio' => 'required|string|max:13',
            'fecha_ingreso_laboral' => 'required|date',
            'numero_empleado_modifica' => 'required|string|max:50',
        ]);

        if ($validator->fails()) {
            return $this->makeResponse(
                true,
                "ERR_MCOMAU_USU_UPD000: Se encontraron uno o más errores.",
                $this->makeErrors($validator->errors()->messages()),
                401
            );
        }

        $user = $request->all();
        $pdo = DB::connection()->getPdo();
        $qryRFCE = "SELECT USUA_RFCE FROM S001V01TUSUA WHERE USUA_IDUS = :idus";
        $gstRFCE = $pdo->prepare($qryRFCE);
        $gstRFCE->bindParam(":idus", $user['numero_empleado_modifica']);

        $gstRFCE->execute();
        $rfce = $gstRFCE->fetchObject()->USUA_RFCE;

        $qryVer = "SELECT * FROM S001V01TUSUA WHERE USUA_IDUS = :num AND USUA_RFCE = :rfce";
        $gstVer = $pdo->prepare($qryVer);

        $gstVer->bindParam(":num", $user["user_id"]);
        $gstVer->bindParam(":rfce", $rfce);

        if($gstVer->execute()){
            if(count($gstVer->fetchAll($pdo::FETCH_ASSOC)) < 1){
                return $this->makeResponse(true, "ERR_MCOMAU_USU_UPD001: El usuario que desea modificar no existe", [], 404);
            }
        }else{
            return $this->makeResponse(true, "ERR_MCOMAU_SER_UPD002: No se pudo consultar el usuario que desea modificar", [], 500);
        }

        $qry = 'UPDATE S001V01TUSUA SET USUA_TURN = :turn, USUA_PERF = :perf, USUA_POLI = :poli, USUA_NOMB = :nomb, USUA_APPA = :appa, USUA_APMA = :apma,  
        USUA_UNNE = :unne, USUA_FEIN = :fein, USUA_USMO = :usmo, USUA_FEMO = :femo, USUA_FEAR = CURRENT_TIMESTAMP WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce';
        $gst = $pdo->prepare($qry);

        $apM = array_key_exists("ape_m", $user) ? $user['ape_m'] : "";
        $femo = Carbon::now()->timezone('America/Mexico_City')->toDateTimeString();

        $gst->bindParam(":turn", $user['turno']);
        $gst->bindParam(":perf", $user['perfil']);
        $gst->bindParam(":poli", $user['politica']);
        $gst->bindParam(":nomb", $user['nombre']);
        $gst->bindParam(":appa", $user['ape_p']);
        $gst->bindParam(":apma", $user['ape_m']);
        $gst->bindParam(":unne", $user['rfc_unidad_negocio']);
        $gst->bindParam(":fein", $user['fecha_ingreso_laboral']);
        $gst->bindParam(":usmo", $user['numero_empleado_modifica']);
        $gst->bindParam(":femo", $femo);
        $gst->bindParam(":idus", $user['user_id']);
        $gst->bindParam(":rfce", $rfce);

        try{
            if (!$gst->execute()) {
                return $this->makeResponse(true, "ERR_MCOMAU_SER_UPD003: No se pudo modificar el usuario.", [], 500);
            }
        }catch(PDOException $e){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_UPD004: " . $e->getMessage(), [], 500);
        }

        return $this->makeResponse(false, "EXITO");
    }

    public function getEmpleados($idus, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));
        $qry = 'SELECT CONCAT(USUA_NOMB, " ", USUA_APPA, " ", IF(ISNULL(USUA_APMA), "", USUA_APMA), " (", USUA_IDUS, ")") AS USUARIO FROM S001V01TUSUA 
            LEFT JOIN S001V01TORGA ON ORGA_IDUS = USUA_IDUS WHERE ORGA_JEDI = :jedi AND USUA_RFCE = :rfce AND USUA_ESTA != "Eliminado"';
        $gst = $pdo->prepare($qry);
        $gst->bindParam(":jedi", $idus);
        $gst->bindParam(":rfce", $rfce);
        if(!$gst->execute()){
            return $this->makeResponse(true, "ERR_MCOMAU_SER_GEM000: No se ejecutó la consulta a la base.", [], 500);
        }

        return $this->makeResponse(false, "EXITO", $gst->fetchAll($pdo::FETCH_ASSOC));
    }

    private function makeResponse($error, $msg, $response = [], $code = 200){
        $respuesta = json_encode([
            "error" => $error,
            "msg" => $msg,
            "response" => $response
        ]);

        return response($respuesta, $code)->header('Content-Type', 'application/json');
    }

    private function makeErrors($erroresObj){
        $erroresArr = array();

        foreach ($erroresObj as $key => $value) {
            foreach ($value as $key0 => $value0) {
                if(array_key_exists($key, $erroresArr)){
                    $val = $erroresArr[$key] . "|" . $value0;
                    $erroresArr[$key] = $val;
                }else{
                    $erroresArr[$key] = $value0;
                }
            }
        }

        return $erroresArr;
    }
}