<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use App\Http\Controllers\EncController;

class MESMHSController extends Controller{
    public function getVacaciones($idus, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));

        $qryPerf = "SELECT USUA_PERF FROM S001V01TUSUA WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce";
        $gstPerf = $pdo->prepare($qryPerf);
        $gstPerf->bindParam(":idus", $idus);
        $gstPerf->bindParam(":rfce", $rfce);

        if(!$gstPerf->execute()){
            return $this->makeResponse(true, "ERR_MESMCV_SER_GSP000: No se ejecutó la consulta del perfil del usuario", [], 500);
        }

        $perf = $gstPerf->fetchObject();

        if(!$perf){
            return $this->makeResponse(true, "ERR_MESMCV_USU_GSP001: El usuario que hace la consulta no existe", [], 404);
        }
        if($perf->USUA_PERF == 1){
            $qry = "SELECT SOVA_IDUS AS IDUSUARIO, CONCAT(USUA_NOMB, ' ', USUA_APPA, ' ', IF(ISNULL(USUA_APMA), '', USUA_APMA)) AS USUARIO, SOVA_IDSO AS IDSOLICITUD, SOVA_FEIN AS FECHAINICIAL, SOVA_FEFI AS FECHAFINAL, SOVA_ESTA AS ESTATUS, PEVA_PEVA AS PERIODOVACACIONAL FROM S001V01TSOVA LEFT JOIN S001V01TPEVA ON PEVA_IDSO = SOVA_IDSO INNER JOIN S001V01TUSUA ON USUA_IDUS = SOVA_IDUS WHERE SOVA_ESTA = 'Aprobado' OR SOVA_ESTA = 'Rechazado' AND SOVA_RFCE = :rfce";
        }else{
            $qry = "SELECT SOVA_IDUS AS IDUSUARIO, SOVA_IDSO AS IDSOLICITUD, SOVA_FEIN AS FECHAINICIAL, SOVA_FEFI AS FECHAFINAL, SOVA_ESTA AS ESTATUS, PEVA_PEVA AS 
            PERIODOVACACIONAL FROM S001V01TSOVA LEFT JOIN S001V01TPEVA ON PEVA_IDSO = SOVA_IDSO WHERE (SOVA_ESTA = 'Aprobado' OR SOVA_ESTA = 'Rechazado') AND 
            SOVA_IDUS = :idus AND SOVA_RFCE = :rfce";
        }
        
        $gst = $pdo->prepare($qry);

        if($perf->USUA_PERF != 1) $gst->bindParam(":idus", $idus);
        $gst->bindParam(":rfce", $rfce);
        
        if(!$gst->execute()){
            return $this->makeResponse(true, "ERR_MESMCC_SER_GVS000: No se ejecutó la consulta a la base", [], 500);
        }

        return $this->makeResponse(true, "EXITO", $gst->fetchAll($pdo::FETCH_ASSOC));
    }

    public function getVacacion($idso, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));
        
        $qry = "SELECT SOVA_IDSO AS IDSOLICITUD, SOVA_FEIN AS FECHAINICIAL, SOVA_FEFI AS FECHAFINAL, SOVA_ESTA AS ESTATUS, PEVA_PEVA AS PERIODOVACACIONAL, PEVA_VAPE 
        AS DIASDISPANTES, PEVA_VAGO AS DIASDISPDESP, IF(ISNULL(SOVA_MORE), '-', SOVA_MORE) AS MOTIVO FROM S001V01TSOVA LEFT JOIN S001V01TPEVA ON PEVA_IDSO = SOVA_IDSO 
        WHERE SOVA_IDSO = :idso AND SOVA_RFCE = :rfce";
        $gst = $pdo->prepare($qry);
        $gst->bindParam(":idso", $idso);
        $gst->bindParam(":rfce", $rfce);
        if(!$gst->execute()){
            return $this->makeResponse(true, "ERR_MESMCC_SER_GVA000: No se ejecutó la consulta a la base", [], 500);
        }

        return $this->makeResponse(true, "EXITO", $gst->fetchObject());
    }

    private function makeResponse($error, $msg, $response = [], $code = 200){
        $respuesta = json_encode([
            "error" => $error,
            "msg" => $msg,
            "response" => $response
        ]);

        return response($respuesta, $code)->header('Content-Type', 'application/json');
    }
}