<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

use App\Http\Controllers\EncController;

class MESMREController extends Controller{
    public function getReportes($idus, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));

        $qry = 'SELECT SOVA_IDSO AS IDSOLICITUD, CONCAT(USUA_NOMB, " ", USUA_APPA, " ", IF(ISNULL(USUA_APMA), "", USUA_APMA), " (", USUA_IDUS, ")") AS NOMBREEMPLEADO, 
        SOVA_FEIN AS FECHAINICIO, SOVA_FEFI AS FECHAFIN, SOVA_NUDI AS NUMERODIAS, SOVA_ESTA AS ESTATUS, PEVA_PEVA AS PERIODOVACACIONAL, PEVA_VAPE AS VACACIONESANTES, 
        PEVA_VAGO AS VACACIONESDESPUES FROM S001V01TUSUA INNER JOIN S001V01TSOVA ON SOVA_IDUS = USUA_IDUS LEFT JOIN S001V01TPEVA ON PEVA_IDSO = SOVA_IDSO 
        WHERE USUA_IDUS = :idus AND USUA_RFCE = :rfce';
        $gst = $pdo->prepare($qry);
        $gst->bindParam(":idus", $idus);
        $gst->bindParam(":rfce", $rfce);
        if(!$gst->execute()){
            return $this->makeResponse(true, "ERR_MESMRE_SER_GRE000: No se ejecutó la consulta de las solicitudes a la base", [], 500);
        }
        return $this->makeResponse(false, "EXITO", $gst->fetchAll($pdo::FETCH_ASSOC));
    }

    public function getReportesTodos($perf, $idus, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));
        
        $qry = 'SELECT SOVA_IDSO AS IDSOLICITUD, CONCAT(USUA_NOMB, " ", USUA_APPA, " ", IF(ISNULL(USUA_APMA), "", USUA_APMA), " (", USUA_IDUS, ")") AS NOMBREEMPLEADO, 
        SOVA_FEIN AS FECHAINICIO, SOVA_FEFI AS FECHAFIN, SOVA_NUDI AS NUMERODIAS, SOVA_ESTA AS ESTATUS, PEVA_PEVA AS PERIODOVACACIONAL, PEVA_VAPE AS VACACIONESANTES, 
        PEVA_VAGO AS VACACIONESDESPUES FROM S001V01TUSUA INNER JOIN S001V01TSOVA ON SOVA_IDUS = USUA_IDUS LEFT JOIN S001V01TPEVA ON PEVA_IDSO = SOVA_IDSO';

        if($perf == 1){
            $qry .= ' INNER JOIN S001V01TORGA ON ORGA_IDUS = USUA_IDUS WHERE ORGA_JEDI = :idus AND USUA_RFCE = :rfce';
        }else{
            $qry .= ' WHERE USUA_RFCE = :rfce';
        }

        $gst = $pdo->prepare($qry);
        
        if($perf == 1){
            $gst->bindParam(":idus", $idus);
        }

        $gst->bindParam(":rfce", $rfce);

        if(!$gst->execute()){
            return $this->makeResponse(true, "ERR_MESMRE_SER_GRE000: No se ejecutó la consulta de las solicitudes a la base", [], 500);
        }
        return $this->makeResponse(false, "EXITO", $gst->fetchAll($pdo::FETCH_ASSOC));
    }

    private function makeResponse($error, $msg, $response = [], $code = 200){
        $respuesta = json_encode([
            "error" => $error,
            "msg" => $msg,
            "response" => $response
        ]);

        return response($respuesta, $code)->header('Content-Type', 'application/json');
    }
}